#! /bin/bash
logger -t webapp "uncmpressConfigFile.sh"

# chooystickのモデル番号
# 最新のモデル番号
AS_CC100_LAST_MODEL_NUMBER=1
# 一番古いモデル番号
AS_CC100_OLDEST_MODEL_NUMBER=1


TMP_DIR=/tmp
PILAB_DIR=/opt/piLab
AS_CC100_DIR=$TMP_DIR/ascc100_1
WORK_DIR=$AS_CC100_DIR/config
COMPRESS_FILE=$TMP_DIR/ascc100_1.zip
AS_CC100_CONFIG_DIR=$PILAB_DIR/config
AS_CC100_CONFIG_BAK_DIR=$TMP_DIR/config_bak
DONT_REMOVE_FILE_LIST=$PILAB_DIR/dont_remove.list
TMPLATE_FILE=CommandTemplate.xml

### 削除対象外のconfig以外を除
if [ ! -e $AS_CC100_CONFIG_BAK_DIR ]; then
	mkdir $AS_CC100_CONFIG_BAK_DIR
fi

# 対象外のリストから一致するconfigを一時的に移動
for confFile in `cat $DONT_REMOVE_FILE_LIST`
do
	if [ -e $AS_CC100_CONFIG_DIR/$confFile ]; then
		sudo mv $AS_CC100_CONFIG_DIR/$confFile $AS_CC100_CONFIG_BAK_DIR/$confFile
	fi
done
sudo mv $AS_CC100_CONFIG_DIR/$TMPLATE_FILE $AS_CC100_CONFIG_BAK_DIR/$TMPLATE_FILE

# config以下削除
sudo rm $AS_CC100_CONFIG_DIR/*
# 一時的に移動したconfigを元に戻す
sudo mv $AS_CC100_CONFIG_BAK_DIR/* $AS_CC100_CONFIG_DIR/

if [ -e $AS_CC100_CONFIG_BAK_DIR ]; then
#	sudo rm -fr $AS_CC100_CONFIG_BAK_DIR/
	rm -fr $AS_CC100_CONFIG_BAK_DIR/
fi

### アップロードしたconfigを展開
cd $TMP_DIR
unzip $COMPRESS_FILE > /dev/null

# 最新のモデルから設定ファイルのディレクトリを検索
# 見つからなければ下位モデルのディレクトリを検索していく
for no in `seq $AS_CC100_LAST_MODEL_NUMBER -1 $AS_CC100_OLDEST_MODEL_NUMBER`
do
	AS_CC100_DIR=`printf "%s/ascc100_%d" $TMP_DIR $no`
	WORK_DIR=`printf "%s/config" $AS_CC100_DIR`
	if [ -e $WORK_DIR ]; then
		break
	fi
done

sudo chown www-data:www-data $WORK_DIR/* 

sudo mv $WORK_DIR/* $AS_CC100_CONFIG_DIR/
sudo chmod 666 $AS_CC100_CONFIG_DIR/*

sudo rm -fr $COMPRESS_FILE $AS_CC100_DIR
