#! /bin/bash

# ascc100のモデル番号
# 最新のモデル番号
AS_CC100_LAST_MODEL_NUMBER=1
# 一番古いモデル番号
AS_CC100_OLDEST_MODEL_NUMBER=1

TMP_DIR=/tmp
WORK_DIR=$TMP_DIR/work
AS_CC100_CONF_DIR=ascc100_1/config
STAT=0

if [ $# -ne 1 ]; then
	exit 1
fi
# アップロードファイル名
ZIP_FILE_NAME=$1

# 作業ディレクトリ作成
mkdir -p $WORK_DIR
# zipを解凍
unzip $TMP_DIR/$ZIP_FILE_NAME -d $WORK_DIR > /dev/null

# ファイル名を強制的に*.zipに変更するので、zip形式でないファイルもzipになるが、
# unzipでエラーが起こるものはzip形式のファイルではないため、エラー
status=`echo $?`
if [ $status -ne 0 ]; then
	STAT=2
fi

conf_key[0]="SensorSetting";
conf_key[1]="DeviceSetting";
conf_key[2]="OperationSetting";

if [ $STAT -eq 0 ]; then
	STAT=3
	# 最新のモデルから下位モデルの設定ファイルを検索する
	for no in `seq $AS_CC100_LAST_MODEL_NUMBER -1 $AS_CC100_OLDEST_MODEL_NUMBER`
	do
		AS_CC100_CONF_DIR=`printf "ascc100_%d/config" $no`
		IS_EXIST_CONF_DIR=0
		if [ -e $WORK_DIR/$AS_CC100_CONF_DIR ]; then
			IS_EXIST_CONF_DIR=1
		fi
		if [ $IS_EXIST_CONF_DIR = 1 ]; then
			if [ ! -e "$WORK_DIR/$AS_CC100_CONF_DIR/http_port.txt" ]; then
				STAT=4
			fi
			if [ ! -e "$WORK_DIR/$AS_CC100_CONF_DIR/interfaces" ]; then
				STAT=4
			fi

			# 必須の設定ファイルがあるかチェック
			for val in "${conf_key[@]}"
			do
				used_xml=`echo "cat /FileList/$val" | xmllint --shell /opt/piLab/config.org/Config.xml`
				file_name=`echo ${used_xml} | sed -e "s/^.*<$val>\(.*\)<\/$val>.*$/\1/"`
				tmpfile_name=`echo ${file_name} | sed -e "s/opt\/piLab/tmp\/work\/ascc100_$no/g"`
				if [ ! -e $tmpfile_name ]; then
					echo $tmpfile_name
					STAT=4
				fi
			done
			if [ $STAT = 3 ]; then
				STAT=0
			fi
			break
	 	fi
	done
fi

if [ $STAT -ne 0 ]; then
	rm -f $TMP_DIR/$ZIP_FILE_NAME
fi
rm -fr $WORK_DIR

exit $STAT
