#! /bin/bash
LOGGER="logger -t web-upload "
AS_CC100_PKG=/opt/installer/ascc100/ascc100.tar.gz
AS_CC100_EVENT_FILE=/opt/installer/INSTALLASCC100
CHKTMP_DIR=/tmp/ascc100
CHECKSUM_FILE=ascc100_1.txt
DEFAULT_DIR=`pwd`
STAT=1
if [ -e $AS_CC100_PKG ] ; then
	mkdir -p $CHKTMP_DIR
	tar zxvfp $AS_CC100_PKG -C $CHKTMP_DIR > /dev/null
	cd $CHKTMP_DIR
	if [ -e $CHECKSUM_FILE ]; then
		md5sum -c $CHECKSUM_FILE > /dev/null
		if [ $? -eq 0 ]; then
			$LOGGER "Software Validation : OK"
			STAT=0
		else
			$LOGGER "Software Validation : NG"
		fi
	else
		$LOGGER "NOT FOUND MD5SUM.TXT. Software Validation will be ABORTED"
	fi

	cd $DEFAULT_DIR
	rm -rf $CHKTMP_DIR
fi
exit $STAT
