#! /bin/bash

TMP_DIR=/tmp
WORK_DIR=$TMP_DIR/work
STAT=0

if [ $# -ne 1 ]; then
	exit 1
fi
# アップロードファイル名
ZIP_FILE_NAME=$1

# 作業ディレクトリ作成
mkdir -p $WORK_DIR
# zipを解凍
unzip $TMP_DIR/$ZIP_FILE_NAME -d $WORK_DIR > /dev/null

# ファイル名を強制的に*.zipに変更するので、zip形式でないファイルもzipになるが、
# unzipでエラーが起こるものはzip形式のファイルではないため、エラー
status=`echo $?`
if [ $status -ne 0 ]; then
	STAT=2
fi

if [ ! -e "$WORK_DIR/CommandTemplate.xml" ]; then
	STAT=4
fi

if [ $STAT -ne 0 ]; then
	rm -f $TMP_DIR/$ZIP_FILE_NAME
fi
rm -fr $WORK_DIR

exit $STAT
