<?php
require('validate.php');
require('files.php');
require('unitSetting.php');
require('cipher.php');
require('../resource.php');

$xml = "../../config/Devices.xml"; //ファイルを指定
$doc = simplexml_load_file($xml);
$array = array(
	"message" => "" ,
	"status" => 0 ,
);
$aesKey=getAesKey($productName, true);

foreach ($doc->Device as $device) {
	$id = (string)$device['id'];
	$key = 'device' . $id . '_ipaddr';
	if (isset($_POST[$key])) {		// IPパラメタがあれば更新処理をする
		// 設定データが全て揃っているか確認
		$deviceParamKeyTmps = array('device' . $id . '_ipaddr', 'device' . $id . '_http_port', 'device' . $id . '_user', 'device' . $id . '_password', 'device' . $id . '_tls', 'device' . $id . '_name', 'device' . $id . '_iv');
		if (validateParams($_POST, $deviceParamKeyTmps)) {
			$value = $_POST[$key];
			$isEnable = strlen($value) > 0;
			$deviceName = "デバイス" . sprintf("%02d", $device['id']);
			if ($isEnable) {
				$value = $_POST[$deviceParamKeyTmps[0]];
				if ((isIpV4Format($value) && validateUnitIpv4Addr($value))
					|| (!isIpV4Format($value) && validateUri($value))){
					$device->IpAddr = $value;
				}
				else{
					$array["message"] = $deviceName ."　アドレスが不正です" ;
					$array["status"] = 1 ;
					goto response;	
				}

				$value = $_POST[$deviceParamKeyTmps[1]];
				if (validatePortNumber($value)) {
					$portNum = intval($value);
					$device->HttpPort = (string)$portNum;
				} else {
					$array["message"] = $deviceName ."　HTTP(S)ポートが不正です" ;
					$array["status"] = 1 ;
					goto response;
				}

				/// tlsの使用
				$value = $_POST[$deviceParamKeyTmps[4]];
				if (validateBool($value)) {
					$device->UseTls = (string)$value;
				} else {
					$array["message"] = $deviceName ."　HTTPS設定が不正です" ;
					$array["status"] = 1 ;
					goto response;
				}


				$value = $_POST[$deviceParamKeyTmps[2]];
				$device->UserID = $value;
				if (validateCameraUserId($value)) {
					$device->UserID = $value;
				} else {
					$array["message"] = $deviceName ."　ユーザー名が不正です" ;
					$array["status"] = 1 ;
					goto response;
				}
				if(strlen($device->UserID) > 0){
					$value = decryptAES($_POST[$deviceParamKeyTmps[3]], $aesKey, $_POST[$deviceParamKeyTmps[6]]);
					if (validateCameraPassword($value)) {
						$device->Password = $value;
					} else {
						$array["message"] = $deviceName ."　パスワードが不正です" ;
						$array["status"] = 1 ;
						goto response;
					}	
				}
				else{
					$device->Password = "";
				}

				// デバイス名称
				$value = $_POST[$deviceParamKeyTmps[5]];
				if(validateDeviceName($value)!==true){
					// $array["message"] = $deviceName ."　" . validateDeviceName($value);
					$array["message"] = $deviceName ."　デバイス名が不正です";
					$array["status"] = 1 ;
					goto response;	
				}
				else{
					$device->Name = $value;
				}

			} else {
				$device->IpAddr = "";
				$device->HttpPort = 80;
				$device->UserID = "";
				$device->Password = "";
				$device->Name = "デバイス" .sprintf( "%02d", $device['id'] );
			}
		}
	}
}
$doc->saveXML($xml);
normalizeSensorSetting();

exec("../../cmd/apps_restart.sh > /dev/null &");

response:
$json = json_encode( $array ) ;
header( "Content-Type: application/json; charset=utf-8" );
echo $json;
