<?php
require('validate.php');

$xml = "../../config/Sensors.xml"; //ファイルを指定
$xmlOpe = "../../config/Operation.xml"; //ファイルを指定
$doc = simplexml_load_file($xml); //xmlを読み込む
$xmlOpeData = simplexml_load_file($xmlOpe);

$doc = simplexml_load_file($xml);
$array = array(
	"message" => "" ,
	"status" => 0 ,
);

$xmlSensorId = (string)"64";		// リカバリー設定保存場所
$sensorDeviceParamKeyTmps = array();
$sensorCommandParamKeyTmps = array();
for( $actionId = 1; $actionId <= 16; $actionId++ ){
	$sensorDeviceParamKeyTmps[$actionId] = 'sensor' . $xmlSensorId . '_action' . $actionId;
	$sensorCommandParamKeyTmps[$actionId] = 'sensor' . $xmlSensorId . '_command' . $actionId;
}
$paramKeys = array('isRecoveryAction', 'recoveryTime');
foreach ($doc->Macro as $sensor) {
	if(64 == $sensor['id']){
		break;
	}
}

// 全てのカメラのプリセット番号がある場合のみ更新
if (64 == $sensor['id'] && validateParams($_POST, $sensorDeviceParamKeyTmps) && validateParams($_POST, $sensorCommandParamKeyTmps) && validateParams($_POST, $paramKeys)) {
	foreach( $sensorDeviceParamKeyTmps as $actionId=>$key){
		if(!validateDeviceId($_POST[$sensorDeviceParamKeyTmps[$actionId]])){
			$array["message"] = "復旧動作の". $actionId ."行目デバイス設定が不正です" ;
			$array["status"] = 1 ;
			goto response;
		}
		if($_POST[$sensorDeviceParamKeyTmps[$actionId]] !== 'unused'){
			if(validateHttpCommand($_POST[$sensorCommandParamKeyTmps[$actionId]])!==true){
				$array["message"] = "復旧動作の". $actionId ."行目コマンド設定が不正です";
				$array["status"] = 1 ;
				goto response;
			}
		}
		else{
			$_POST[$sensorCommandParamKeyTmps[$actionId]] = "/";
		}
	}
	if(!validateBool($_POST[$paramKeys[0]])){
		$array["message"] = "復旧動作設定が不正です";
		$array["status"] = 1 ;
		goto response;
	}
	if(!validateNumber($_POST[$paramKeys[1]],0,120)){
		$array["message"] = "復旧開始時間設定が不正です";
		$array["status"] = 1 ;
		goto response;
	}

	/// 設定の保存
	foreach($sensor as $action){
		$actionId = $action['id'];
		$value = $_POST['sensor' . $xmlSensorId . '_action' . $actionId];
		$action->ActionType = $value;
		$value = $_POST['sensor' . $xmlSensorId . '_command' . $actionId];
		$action->Command = $value;
	}	
	$xmlOpeData->EnableRecoveryAction = $_POST[$paramKeys[0]];
	$xmlOpeData->RecoveryTime = $_POST[$paramKeys[1]];
	$doc->saveXML($xml);
	$xmlOpeData->saveXML($xmlOpe);
	exec("../../cmd/apps_restart.sh > /dev/null &");	
}


response:
$json = json_encode( $array ) ;
header( "Content-Type: application/json; charset=utf-8" );
echo $json;
