<?php
require('validate.php');

$xml = "../../config/Sensors.xml"; //ファイルを指定
$doc = simplexml_load_file($xml);
$array = array(
	"message" => "" ,
	"status" => 0 ,
);

foreach ($doc->Macro as $sensor) {
	$xmlSensorId = (string)$sensor['id'];
	$sensorDeviceParamKeyTmps = array();
	$sensorCommandParamKeyTmps = array();
	for( $actionId = 1; $actionId <= 16; $actionId++ ){
		$sensorDeviceParamKeyTmps[$actionId] = 'sensor' . $xmlSensorId . '_action' . $actionId;
		$sensorCommandParamKeyTmps[$actionId] = 'sensor' . $xmlSensorId . '_command' . $actionId;
	}

	// 全てのカメラのプリセット番号がある場合のみ更新
	if (validateParams($_POST, $sensorDeviceParamKeyTmps) && validateParams($_POST, $sensorCommandParamKeyTmps)) {
		/// パラメータの有効性確認
		foreach( $sensorDeviceParamKeyTmps as $actionId=>$key){
			if(!validateDeviceId($_POST[$sensorDeviceParamKeyTmps[$actionId]])){
				$array["message"] = $sensor["name"] ."の". $actionId ."行目デバイス設定が不正です" ;
				$array["status"] = 1 ;
				goto response;
			}
			if($_POST[$sensorDeviceParamKeyTmps[$actionId]] === 'Wait'){
				if(validateNumber($_POST[$sensorCommandParamKeyTmps[$actionId]], 1, 120 )!==true){
					$array["message"] = $sensor["name"] ."の". $actionId ."行目時間設定が不正です";
					$array["status"] = 1 ;
					goto response;
				}
			}
			else if($_POST[$sensorDeviceParamKeyTmps[$actionId]] !== 'unused'){
				if(validateHttpCommand($_POST[$sensorCommandParamKeyTmps[$actionId]])!==true){
					$array["message"] = $sensor["name"] ."の". $actionId ."行目コマンド設定が不正です";
					$array["status"] = 1 ;
					goto response;
				}
			}
			else{
				$_POST[$sensorCommandParamKeyTmps[$actionId]] = "/";
			}
		}
		foreach($sensor as $action){
			$actionId = $action['id'];
			$value = $_POST['sensor' . $xmlSensorId . '_action' . $actionId];
			$action->ActionType = $value;
			$value = $_POST['sensor' . $xmlSensorId . '_command' . $actionId];
			$action->Command = $value;
		}	
	}
}
// print_r($doc);

$doc->saveXML($xml);
exec("../../cmd/apps_restart.sh > /dev/null &");

response:
$json = json_encode( $array ) ;
header( "Content-Type: application/json; charset=utf-8" );
echo $json;
