<?php
require('resource.php');

$xml = "../config/Sensors.xml"; //ファイルを指定
$xmlCmdTmp = "../config/CommandTemplate.xml"; //ファイルを指定
$xmlOpe = "../config/Operation.xml"; //ファイルを指定
$xmlData = simplexml_load_file($xml); //xmlを読み込む
$xmlCmdTmpData = simplexml_load_file($xmlCmdTmp); //xmlを読み込む
$xmlOpeData = simplexml_load_file($xmlOpe);
// $jsonArray['enable_sensor'] = (string)($xmlOpeData->EnableSensor);

$jsonSensors = array();
$jsonList = array();

$base_sensor = 64;
$sensor_count = 1;
$endIndex = $base_sensor + $sensor_count;

// 空要素を生成(xmlのデータなしのケースでもデータを返信する)
$emptySensor = array('id' => '1', 'Action'=>array());
for($index = 1; $index<=16; $index++){
    $emptySensor['Action'][strval($index)] = array('ActionType'=>'unused','Command'=>'');
}

for ($index = $base_sensor; $index < $endIndex; $index++) {
	$emptySensor['id'] = $index;
	$jsonList[$index] = $emptySensor;
}

foreach ($xmlData->Macro as $sensor) {
	/// ID
	foreach ($sensor->attributes() as $key => $value) {
		$jsonSensors[$key] = (string)$value;
	}
	foreach ($sensor->children() as $value) {
        $jsonSensors['Action'][strval($value->attributes()->id)] = $value;
	}
	if ($base_sensor <= $jsonSensors['id'] && $jsonSensors['id'] < $endIndex) {
		$jsonList[$jsonSensors['id']] = $jsonSensors;
	}
}
print('<input id="base" type="hidden" value="' . $base_sensor . '"/>' . PHP_EOL);
print('<input id="num" type="hidden" value="' . $sensor_count . '"/>' . PHP_EOL);
$recveryTimeList = array(10, 15, 30, 60);
$deviceList = array('unused'=>'制御しない');
$deviceList += getDeviceList();
// var_dump($deviceList);
foreach ($jsonList as $sensor) {
	print('<p class="table_title">復旧動作</p>' . PHP_EOL);
	print('<table border="2" width="750px">' . PHP_EOL);
    print('<tr><th colspan="2">' . PHP_EOL);
    if(0 == strcasecmp($xmlOpeData->EnableRecoveryAction,"true")){
        print('<input type="checkbox" id="isRecoveryAction" checked="checked">復旧動作する</input>' . PHP_EOL);
    }
    else{
        print('<input type="checkbox" id="isRecoveryAction">復旧動作する</input>' . PHP_EOL);
    }
    // print('&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;復旧開始時間<input class="positive-integer input-mini" type="text" id="recoveryTime" maxlength="3" value="'. $xmlOpeData->RecoveryTime . '" /> 秒後' . PHP_EOL);
    print('&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;復旧開始時間<select id="recoveryTime" value="'. $xmlOpeData->RecoveryTime . '" style="width: 150px" >' . PHP_EOL);
    foreach( $recveryTimeList as $value) {
        if ($value == $xmlOpeData->RecoveryTime) {
            print('<option value="' . $value . '" selected>' . $value . '</option>' . PHP_EOL);
        } else {
            print('<option value="' . $value . '">' . $value . '</option>' . PHP_EOL);
        }
    }
    print('</select>&emsp;秒後</th></tr>' . PHP_EOL);
    
    print('<tr><th width="100px">制御対象</th><th>コマンド</th></tr>' . PHP_EOL);
    foreach($sensor['Action'] as $action){
        print('<tr><td width="100px">' . PHP_EOL);
        print('<select id="sensor' . $sensor['id'] . '_action' . $action->attributes()->id . '" value="' . $action->ActionType . '" style="width: 150px" >' . PHP_EOL);
        foreach ($deviceList as $key => $value) {
            if ($key == $action->ActionType) {
                print('<option value="' . $key . '" selected>' . $value . '</option>' . PHP_EOL);
            } else {
                print('<option value="' . $key . '">' . $value . '</option>' . PHP_EOL);
            }
        }
        print('</select></td>' . PHP_EOL);
        print('<td>' . PHP_EOL);
        $cmd = str_replace('"','&quot;',$action->Command);
        print('<input class="input-xxlarge" type="text" width="300px" id="sensor' . $sensor['id'] . '_command' . $action->attributes()->id . '" maxlength="253"  list="cmd_list" value="' . $cmd . '"/>' . PHP_EOL);
        print('</td></tr>' . PHP_EOL);
    }
	print('</table><br>' . PHP_EOL);
}
print('<datalist id="cmd_list">');
foreach($xmlCmdTmpData->Command as $commandTmp){
    if($commandTmp != "/"){
        print('<option value="' . $commandTmp . '">'. $commandTmp['name'] .'</option>');
    }
}
print('</datalist>');

print('<br><br><br>'  . PHP_EOL);
print('<footer><div class="button_place"><button type="button" class="btn btn-primary btn-lg" style="margin-right: 5px;" id="command_setting">設定</button><button type="button" class="btn btn-primary btn-lg" style="margin-left: 5px;" id="clear_setting">クリア</button></div></footer>');
