<?php
require('resource.php');

$xml = "../config/Sensors.xml"; //ファイルを指定
$xmlCmdTmp = "../config/CommandTemplate.xml"; //ファイルを指定
$xmlData = simplexml_load_file($xml); //xmlを読み込む
$xmlCmdTmpData = simplexml_load_file($xmlCmdTmp); //xmlを読み込む
$jsonSensors = array();
$jsonList = array();

$base_sensor = $_GET['base'];
$sensor_count = $_GET['num'];
$endIndex = $base_sensor + $sensor_count;
if($endIndex >= 64){
    $endIndex = 64;
}

// 空要素を生成(xmlのデータなしのケースでもデータを返信する)
$emptySensor = array('id' => '1', 'Action'=>array());
for($index = 1; $index<=16; $index++){
    $emptySensor['Action'][strval($index)] = array('ActionType'=>'unused','Command'=>'');
}

for ($index = $base_sensor; $index < $endIndex; $index++) {
	$emptySensor['id'] = $index;
	$jsonList[$index] = $emptySensor;
}

foreach ($xmlData->Macro as $sensor) {
	/// ID
	foreach ($sensor->attributes() as $key => $value) {
		$jsonSensors[$key] = (string)$value;
	}
	foreach ($sensor->children() as $value) {
        $jsonSensors['Action'][strval($value->attributes()->id)] = $value;
	}
	if ($base_sensor <= $jsonSensors['id'] && $jsonSensors['id'] < $endIndex) {
		$jsonList[$jsonSensors['id']] = $jsonSensors;
	}
    if($jsonSensors['id'] <= 8){    /// コピー元センサー名称を保存
        $srcSensorName[$jsonSensors['id']] = $jsonSensors["name"];
    }
}
print('<input id="base" type="hidden" value="' . $base_sensor . '"/>' . PHP_EOL);
print('<input id="num" type="hidden" value="' . $sensor_count . '"/>' . PHP_EOL);
$deviceList = array('unused'=>'制御しない');
$deviceList += getDeviceList();
$deviceList += array('Wait'=>'待ち時間(秒)');
// var_dump($deviceList);
foreach ($jsonList as $sensor) {
	print('<p class="table_title">' . $sensor['name'] . '</p>' . PHP_EOL);
	print('<table border="2" width="750px">' . PHP_EOL);
    print('<tr><th>No.</th><th>制御対象</th><th>コマンド (待ち時間)</th></tr>' . PHP_EOL);
    foreach($sensor['Action'] as $action){
        print('<tr><td>' . sprintf( "%02d", $action->attributes()->id ) . '</td>'. PHP_EOL);
        print('<td>' . PHP_EOL);
        print('<select id="sensor' . $sensor['id'] . '_action' . $action->attributes()->id . '" value="' . $action->ActionType . '" style="width: 130px" >' . PHP_EOL);
        foreach ($deviceList as $key => $value) {
            if ($key == $action->ActionType) {
                print('<option value="' . $key . '" selected>' . $value . '</option>' . PHP_EOL);
            } else {
                print('<option value="' . $key . '">' . $value . '</option>' . PHP_EOL);
            }
        }
        print('</select>' . PHP_EOL);

        print('<script>' . PHP_EOL);
        print('$("#sensor' . $sensor['id'] . '_action' . $action->attributes()->id . '").on("change", function(){' . PHP_EOL);
        print('if($("#sensor' . $sensor['id'] . '_action' . $action->attributes()->id . '").val()=="unused"){' . PHP_EOL);
        print('$("#sensor' . $sensor['id'] . '_command' . $action->attributes()->id . '").prop("disabled",true);' . PHP_EOL);
        print('$("#sensor' . $sensor['id'] . '_command' . $action->attributes()->id . '").val("/");' . PHP_EOL);
        print('}else{' . PHP_EOL);
        print('$("#sensor' . $sensor['id'] . '_command' . $action->attributes()->id . '").prop("disabled",false);' . PHP_EOL);
        print('}' . PHP_EOL);
        print('});' . PHP_EOL);
        print('</script>' . PHP_EOL);
        print('</td>' . PHP_EOL);
        print('<td>' . PHP_EOL);
        $cmd = str_replace('"','&quot;',$action->Command);
        $disableAction = "";
        if($action->ActionType=="unused"){
            $disableAction = "disabled";
        }
        // print('<input class="input-xxlarge" type="text" width="300px" id="sensor' . $sensor['id'] . '_command' . $action->attributes()->id . '" maxlength="253"  value="' . $cmd . '"/>' . PHP_EOL);
        print('<input class="input-xxlarge" type="text" width="300px" id="sensor' . $sensor['id'] . '_command' . $action->attributes()->id . '" maxlength="253"  list="cmd_list" value="' . $cmd .'" ' .$disableAction. '/>' . PHP_EOL);
        print('</td></tr>' . PHP_EOL);
    }
	print('</table>' . PHP_EOL);
	print('<div style="text-align:right">');
    print('<select id="src_sensor' . $sensor['id'] . '" style="width: 150px" >' . PHP_EOL);
    for ($srcSensorId = 1; $srcSensorId <= 8; $srcSensorId++) {
        if ($srcSensorId != $sensor['id']) {
            print('<option value="' . $srcSensorId . '">' . $srcSensorName[$srcSensorId] . '</option>' . PHP_EOL);
        }
    }
    print('</select>' . PHP_EOL);
	print('の設定をコピー');
    print('<button type="button" class="btn btn-primary btn-lg" style="margin-right: 5px;" onclick="getSensorInfo(' . $sensor['id']. ');" id="getSensorButton' . $sensor['id'].'">実行</button>');
	print('</div>');
    print('<br>');

}
print('<datalist id="cmd_list">');
foreach($xmlCmdTmpData->Command as $commandTmp){
    if($commandTmp != "/"){
        print('<option value="' . $commandTmp . '">'. $commandTmp['name'] .'</option>');
    }
}
print('</datalist>');

print('<br><br><br>'  . PHP_EOL);
print('<footer><div class="button_place"><button type="button" class="btn btn-primary btn-lg" style="margin-right: 5px;" id="command_setting">設定</button><button type="button" class="btn btn-primary btn-lg" style="margin-left: 5px;" id="clear_setting">クリア</button></div></footer>');
