function setDeviceSetting() {
	$.blockUI();
	var send_data = "";
	var setDeviceListUrl = createCgiUrl(location, "setDeviceList.php");
	const productInfo = getProductInfo();
	const key = getAesKey( productInfo.name, true );

	start = Number($("#device_base").val());
	end = Number(start) + Number($("#device_num").val());
	for (; start < end; start++) {
		if (send_data != "") {
			send_data += "&";
		}
		const iv = generateIV();
		const encrypted = encryptAES($("#device" + start + "_password").val(), key, iv );
		send_data +=
			"device" +
			start +
			'_name=' +
			encodeURIComponent($("#device" + start + "_name").val()) +
			'&' +
			"device" +
			start +
			'_ipaddr=' +
			encodeURIComponent($("#device" + start + "_ipaddr").val()) + 
			'&' +
			"device" +
			start +
			'_http_port=' +
			$("#device" + start + "_http_port").val() +
			'&' +
			"device" +
			start +
			'_tls=' +
			$("#device" + start + "_tls").prop('checked') + 
			'&' +
			"device" +
			start +
			'_user=' +
			encodeURIComponent($("#device" + start + "_user").val()) + 
			'&' +
			"device" +
			start +
			'_password=' +
			encodeURIComponent(encrypted) +
			'&' +
			"device" +
			start +
			'_iv=' + iv;
	}

	$.ajax({
		async: true,
		url: setDeviceListUrl,
		data: send_data,
		type: "POST",
		dataType: "json",
		success: function (res) {
			$.unblockUI();
			if (res["status"] != 0) {
				alert(res["message"]);
			}
			else{
				loadDeviceList($("#device_base").val(),$("#device_num").val(), true);
				$('body,html').animate({ scrollTop: 0 }, 500);
			}
		},
		error: function (xhr, ajaxOptions, thrownError) {
			alert("接続エラー");
//			loadDeviceList($("#device_base").val(), true);
			$.unblockUI();
		},
	});
}
function clearDeviceSetting() {
	start = Number($("#device_base").val());
	end = Number(start) + Number($("#device_num").val());
	for (; start < end; start++) {
		$key = "#device" + start + "_ipaddr";
		// $("#device" + start + "_name").val("Panasonic1");
		$("#device" + start + "_ipaddr").val("");
		$("#device" + start + "_http_port").val("80");
		$("#device" + start + "_user").val("");
		$("#device" + start + "_password").val("");
	}
}
function copyDeviceSetting() {
	srcDevice = Number($("#device_base").val())
	start = srcDevice + 1;
	end = Number(start) + Number($("#device_num").val());
	for (; start < end; start++) {
		$("#device" + start + "_name").val($("#device" + srcDevice + "_name").val());
		$("#device" + start + "_ipaddr").val($("#device" + srcDevice + "_ipaddr").val());
		$("#device" + start + "_http_port").val($("#device" + srcDevice + "_http_port").val());
		$("#device" + start + "_user").val($("#device" + srcDevice + "_user").val());
		$("#device" + start + "_password").val($("#device" + srcDevice + "_password").val());
	}
}

function createDeviceTemplate(deviceInfo,key) {
  const ID = `device${deviceInfo.id}`;
  const decrypted = decryptAES(deviceInfo.Password, key, deviceInfo.iv );
  const escapedName = escapeHtmlAttr(deviceInfo.Name);
  return `
    <p class="table_title">デバイス${deviceInfo.id.toString().padStart(2, '0')}</p>
    <table border="2" width="750px">
	<tbody>
        <tr>
          <th>デバイス名</th>
          <td colspan="2">
            <input class="input-xxlarge" type="text" width="300px" id="${ID}_name" maxlength="253" value="${escapedName}">
          </td>
        </tr>
        <tr>
          <th>アドレス</th>
          <td colspan="2">
            <input class="input-xxlarge" type="text" width="300px" id="${ID}_ipaddr" maxlength="253"  value="${deviceInfo.IpAddr}"/>
        </tr>
        <tr>
          <th>HTTP(S)ポート</th>
          <td colspan="2">
            <input class="positive-integer input-mini" type="text" width="300px" id="${ID}_http_port" maxlength="5" value="${deviceInfo.HttpPort}">
            <input type="checkbox" id="${ID}_tls" ${String(deviceInfo.UseTls).trim().toLowerCase() === "true" ? "checked" : ""}> HTTPSを使う
          </td>
        </tr>
        <tr>
          <th>ユーザー名</th>
          <td colspan="2">
            <input type="text" id="${ID}_user" maxlength="32" value="${deviceInfo.UserID}">
          </td>
        </tr>
        <tr>
          <th>パスワード</th>
          <td colspan="2">
            <input type="password" id="${ID}_password" maxlength="32" value="${decrypted}">
          </td>
        </tr>
      </tbody>
    </table>
  `;
}

function createDeviceSettingFooter(base, num ) {
  copyButton = "";

  if(num >= 3){
  copyButton = `
 	<button type="button" class="btn btn-primary btn-lg" style="margin-left: 100px;" id="copy_setting">コピー</button>
	<div style="text-align:right"><small><small>
	※コピーボタンを押すとデバイス${base.toString().padStart(2, '0')}の設定が、デバイス${(base+1).toString().padStart(2, '0')}～${(base-1+num).toString().padStart(2, '0')}にコピーされます
	</small></small></div>
  `;
  }
  return `<br><br><br>
  <footer><div class="button_place">
    <button type="button" class="btn btn-primary btn-lg" style="margin-right: 5px;" id="device_setting">設定</button>
	<button type="button" class="btn btn-primary btn-lg" style="margin-left: 5px;" id="clear_setting">クリア</button>
  	${copyButton}
  </div></footer>
  <input id="device_base" type="hidden" value="${base}"/>
  <input id="device_num" type="hidden" value="${num}"/>
  `;
}

function getDeviceSetting(base,num) {
	const productInfo = getProductInfo();
	const key = getAesKey( productInfo.name, true );


	var getDeviceListUrl = "cgi-bin/getDeviceList.php?device_base=" + base + "&device_num=" + num;
	$.ajax({
		async: true,
		url: getDeviceListUrl,
		type: "GET",
		dataType: "json",
		success: function (deviceList) {
			$("#device_content").empty();
			deviceList.devices.forEach(element => {
				$("#device_content").append(createDeviceTemplate(element,key));
			});
			$("#device_content").append(createDeviceSettingFooter(Number(base), Number(num)));
		},
	});
}
