function setSensorSetting() {
	$.blockUI();
	var send_data = "";
	var setCcommandListUrl = createCgiUrl(location, "setSensorList.php");

	start = Number($("#base").val());
	end = Number(start) + Number($("#num").val());
	actionMax = 16;
	for (; start < end; start++) {
		if (send_data != "") {
			send_data += "&";
		}
		for( actionNum = 1; actionNum <= actionMax; actionNum++){
			send_data +="sensor" + start + "_action" + actionNum + "=" + encodeURIComponent($("#sensor" + start + "_action" + actionNum).val());
			send_data +="&sensor" + start + "_command" + actionNum + "=" + encodeURIComponent($("#sensor" + start + "_command" + actionNum).val());
			if(actionNum < actionMax){
				send_data += "&";
			}
		}
	}
	$.ajax({
		async: true,
		url: setCcommandListUrl,
		data: send_data,
		type: "POST",
		dataType: "json",
		success: function (res) {
			$.unblockUI();
			if (res["status"] != 0) {
				alert(res["message"]);
			}
			else{
				loadSensorList($("#base").val(), $("#num").val(), true);
				$('body,html').animate({ scrollTop: 0 }, 500);
			}
		},
		error: function (xhr, ajaxOptions, thrownError) {
			alert("接続エラー");
//			loadSensorList($("#base").val(), true);
			$.unblockUI();
		},
	});
}

function getSensorInfo(destSensor) {
	srcSensor = $("#src_sensor" + destSensor).val();
	actionMax = 16;

	var getSensorInfoUrl = createCgiUrl(
		location,
		"getSensorInfo.php?sensor=" + srcSensor
	);

	$.ajax({
		async: true,
		url: getSensorInfoUrl,
		type: "GET",
		dataType: "json",
		success: function (sensorInfo) {
			for( actionNum = 1; actionNum <= actionMax; actionNum++){
				$("#sensor" + destSensor + "_action" + actionNum).val(sensorInfo.Action[actionNum].ActionType);
				$("#sensor" + destSensor + "_command" + actionNum).val(sensorInfo.Action[actionNum].Command);
			}
		},
		error: function (xhr, ajaxOptions, thrownError) {
			alert("接続エラー");
		},

	});
}

function loadSensorList(base, num, force) {
	if (force || base != $("input[name='tab_home']:checked").val()) {
		$("#sensor_content").load("getSensorList.php?base=" + base +"&num=" + num, function () {
			//$.getScript でスクリプトを読み込む
			$("#command_setting").click(function () {
				setSensorSetting();
			});
			$("#clear_setting").click(function () {
				loadSensorList($("#base").val(), $("#num").val(), true);
			});
			$("input[name='tab_home']").val([base]);
		});
	}
}

function setRecoverySensor() {
	$.blockUI();
	var send_data = "";
	var setCcommandListUrl = createCgiUrl(location, "setRecoverySensor.php");

	start = Number($("#base").val());
	end = Number(start) + Number($("#num").val());
	actionMax = 16;
	isEnable = $("#isRecoveryAction").prop("checked");
	send_data = "isRecoveryAction=" + isEnable + "&recoveryTime=" + $("#recoveryTime").val();

	for (; start < end; start++) {
		for( actionNum = 1; actionNum <= actionMax; actionNum++){
			send_data +="&sensor" + start + "_action" + actionNum + "=" + encodeURIComponent($("#sensor" + start + "_action" + actionNum).val());
			send_data +="&sensor" + start + "_command" + actionNum + "=" + encodeURIComponent($("#sensor" + start + "_command" + actionNum).val());
		}
	}

	$.ajax({
		async: true,
		url: setCcommandListUrl,
		data: send_data,
		type: "POST",
		dataType: "json",
		success: function (res) {
			$.unblockUI();
			if (res["status"] != 0) {
				alert(res["message"]);
			}
			else{
				loadRecoverySensor($("#base").val(), $("#num").val(), true);
				$('body,html').animate({ scrollTop: 0 }, 500);
			}
		},
		error: function (xhr, ajaxOptions, thrownError) {
			alert("接続エラー");
//			loadRecoverySensor($("#base").val(), true);
			$.unblockUI();
		},
	});
}

function loadRecoverySensor(base, num, force) {
	if (force || base != $("input[name='tab_home']:checked").val()) {
		$("#sensor_content").load("getRecoverySensor.php", function () {
			//$.getScript でスクリプトを読み込む
			$("#command_setting").click(function () {
				setRecoverySensor();
			});
			$("#clear_setting").click(function () {
				loadRecoverySensor($("#base").val(), $("#num").val(), true);
			});
			$("input[name='tab_home']").val([base]);
		});
	}
}
