<?php


function getDeviceList()
{
    $xml = "../config/Devices.xml"; //ファイルを指定
    $xmlData = simplexml_load_file($xml); //xmlを読み込む
    $deviceList = array();
	$prefixDevice ="Device_";

    foreach ($xmlData as $device) {
        if ( null !== $device->IpAddr && 0 < strlen($device->IpAddr)) {
            $deviceList[$prefixDevice . strval($device->attributes()->id)] = $device->Name;
        }
    }
    return $deviceList;
}

function normalizeSensorSetting()
{
	$xmlDevice = "../../config/Devices.xml"; //ファイルを指定
	$docDevice = simplexml_load_file($xmlDevice);
	$prefixDevice ="Device_";

	$deviceList = array();
	foreach ($docDevice->Device as $device) {
		if ( null !== $device->IpAddr && 0 < strlen($device->IpAddr)) {
			$deviceList[$prefixDevice . strval($device->attributes()->id)] = true;
		}
		else{
			$deviceList[$prefixDevice . strval($device->attributes()->id)] = false;
		}
	}


	$xmlSensor = "../../config/Sensors.xml"; //ファイルを指定
	$docSensor = simplexml_load_file($xmlSensor);

	foreach ($docSensor->Macro as $sensor) {
		foreach ($sensor as $action) {
			$camNum = substr($action->ActionType,strlen($prefixDevice));
            if(validateNumber($camNum,1,99)){
                if (!$deviceList[(string)$action->ActionType]) {
                    $action->ActionType = 'unused';
                    $action->Command = '/';
                }    
            }
		}
	}
	$docSensor->saveXML($xmlSensor);
}
